/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import zathrox.explorercraft.util.ConfigHandler;
import zathrox.explorercraft.world.biome.BiomeSnowdonia;
import zathrox.explorercraft.world.generation.WorldGenStructure;

public class WorldGenStructures
implements IWorldGenerator {
    public static final WorldGenStructure WIZARD_TOWER = new WorldGenStructure("wizard_tower", 7, 8, 19, true);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.generateStructure(WIZARD_TOWER, world, random, chunkX, chunkZ, 120, ConfigHandler.spawnWizardTower, ConfigHandler.wizardTowerChance, (Block)Blocks.field_150349_c, BiomeSnowdonia.class);
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int height, boolean allowed, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = WorldGenStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (allowed && world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0 && pos.func_177956_o() >= height) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

