/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.util;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import zathrox.explorercraft.ExplorerCraft;

public class ConfigHandler {
    public static Configuration config;
    public static boolean spawnBambooForest;
    public static boolean spawnForestedMountain;
    public static boolean spawnSnowdonia;
    public static int bambooForestWeight;
    public static int forestedMountainWeight;
    public static int snowdoniaWeight;
    public static boolean spawnMarble;
    public static boolean spawnBasalt;
    public static boolean spawnJade;
    public static boolean spawnRuby;
    public static boolean spawnAmethyst;
    public static int marbleChance;
    public static int basaltChance;
    public static int marbleVeinSize;
    public static int basaltVeinSize;
    public static boolean spawnAshTree;
    public static boolean spawnLargeDungeon;
    public static boolean spawnWizardTower;
    public static boolean spawnWatergrass;
    public static boolean spawnNoctilucas;
    public static int ashTreeChance;
    public static int largeDungeonChance;
    public static int wizardTowerChance;
    public static boolean swimmingHorse;

    public static void init(File file) {
        config = new Configuration(file);
        String category = "1. Spawn Biomes";
        config.addCustomCategoryComment(category, "Disable spawning of the biomes in the mod, DISABLING these may affect Advancement progression");
        spawnBambooForest = config.getBoolean("Spawn Bamboo Forest", category, true, "Set to false to disable the 'Bamboo Forest' biome");
        spawnForestedMountain = config.getBoolean("Spawn Forested Mountains", category, true, "Set to false to disable the 'Forested Mountain' biome");
        spawnSnowdonia = config.getBoolean("Spawn Snowdonia", category, true, "Set to false to disable the 'Snowdonia' biome");
        category = "2. Biome Controllers";
        config.addCustomCategoryComment(category, "Various settings for controlling the biomes in the mod");
        bambooForestWeight = config.getInt("Bamboo Forest Weight", category, 10, 0, 100, "Set to 0 for no spawn, increase value to increase frequency");
        forestedMountainWeight = config.getInt("Forested Mountain Weight", category, 10, 0, 100, "Set to 0 for no spawn, increase value to increase frequency");
        snowdoniaWeight = config.getInt("Snowdonia Weight", category, 10, 0, 100, "Set to 0 for no spawn, increase value to increase frequency");
        category = "3. Spawn World Generation";
        config.addCustomCategoryComment(category, "Control the various world generation that spawns in Explorercraft, DISABLING these may affect Advancement progression");
        spawnMarble = config.getBoolean("Spawn Marble in Overworld", category, true, "Set to false to disable naturally spawning Marble in the overworld");
        spawnBasalt = config.getBoolean("Spawn Basalt in Overworld", category, true, "Set to false to disable naturally spawning Basalt in the overworld");
        spawnJade = config.getBoolean("Spawn Jade in Overworld", category, true, "Set to false to disable naturally spawning Jade in the overworld");
        spawnRuby = config.getBoolean("Spawn Ruby in Overworld", category, true, "Set to false to disable naturally spawning Ruby in the overworld");
        spawnAmethyst = config.getBoolean("Spawn Amethyst in Overworld", category, true, "Set to false to disable naturally spawning Amethyst in the overworld");
        category = "4. World Generation Controllers";
        config.addCustomCategoryComment(category, "Fine tune the world generation that spawns in Explorercraft");
        marbleVeinSize = config.getInt("Size of Marble Vein", category, 33, 0, 33, "Decrease value to reduce the amount of marble that spawns in the world, by design this is set to the same value as Diorite, Granite and Andersite");
        basaltVeinSize = config.getInt("Size of Basalt Vein", category, 33, 0, 33, "Decrease value to reduce the amount of marble that spawns in the world, by design this is set to the same value as Diorite, Granite and Andersite");
        marbleChance = config.getInt("Chance of spawning Marble", category, 8, 0, 100, "Increase value to increase the chances of Marble spawning");
        basaltChance = config.getInt("Chance of spawning Basalt", category, 8, 0, 100, "Increase value to increase the chances of Basalt spawning");
        category = "5. Spawn Structures";
        config.addCustomCategoryComment(category, "Disable the Structures that spawn in Explorercraft");
        spawnAshTree = config.getBoolean("Spawn Ash Trees", category, true, "Set to false to disable Ash Trees from spawning");
        spawnLargeDungeon = config.getBoolean("Spawn Large Dungeons", category, true, "Set to false to disable the Large Dungeons from spawning");
        spawnWizardTower = config.getBoolean("Spawn Wizards Tower", category, true, "Set to false to disable the Wizards Tower from spawning");
        spawnWatergrass = config.getBoolean("Spawn water grass", category, true, "Set to false to disable the water grass from spawning");
        spawnNoctilucas = config.getBoolean("Spawn noctilucas", category, true, "Set to false to disable the noctilucas from spawning");
        category = "6. Structure Controllers";
        config.addCustomCategoryComment(category, "Control the Structures that spawns in Explorercraft");
        ashTreeChance = config.getInt("Chance of spawning Ash Trees", category, 70, 0, 1000, "Increase the value to make spawn less frequent");
        largeDungeonChance = config.getInt("Chance of spawning the Large Dungeons", category, 30, 0, 100, "Increase the value to make Large Dungeons spawn less frequent");
        wizardTowerChance = config.getInt("Chance of spawning the Wizard Tower", category, 20, 0, 100, "Increase the value to make Wizard Towers spawn less frequent");
        category = "7. Vanilla Tweaks";
        config.addCustomCategoryComment(category, "Control how the vanilla tweaks to the game handle");
        swimmingHorse = config.getBoolean("Allow Swimming Horses", category, true, "Disable to turn the swimming horses back to vanilla styled mechanics");
        config.save();
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        ExplorerCraft.config = new File(event.getModConfigurationDirectory() + "/" + "explorercraft");
        ExplorerCraft.config.mkdirs();
        ConfigHandler.init(new File(ExplorerCraft.config.getPath(), "explorercraft.cfg"));
    }
}

