/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.init;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zathrox.explorercraft.util.ConfigHandler;
import zathrox.explorercraft.world.biome.BiomeBambooForest;
import zathrox.explorercraft.world.biome.BiomeSnowdonia;

public class BiomesRegistry {
    public static final Biome BAMBOO_FOREST = new BiomeBambooForest(new Biome.BiomeProperties("Bamboo Forest").func_185410_a(0.9f).func_185395_b(1.0f).func_185400_d(0.4f));
    public static final Biome FORESTED_MOUNTAIN = new BiomeForest(BiomeForest.Type.NORMAL, new Biome.BiomeProperties("Forested Mountain").func_185398_c(0.1f).func_185400_d(1.3f).func_185399_a("forest"));
    public static final Biome SNOWDONIA = new BiomeSnowdonia(new Biome.BiomeProperties("Snowdonia").func_185398_c(0.6f).func_185400_d(1.0f).func_185395_b(1.0f));

    public static void registerBiomes() {
        BiomesRegistry.explorerBiome(BAMBOO_FOREST, "bamboo_forest", ConfigHandler.bambooForestWeight, true, ConfigHandler.spawnBambooForest, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST);
        BiomesRegistry.explorerBiome(FORESTED_MOUNTAIN, "forested_mountain", ConfigHandler.forestedMountainWeight, false, ConfigHandler.spawnForestedMountain, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST);
        BiomesRegistry.explorerBiome(SNOWDONIA, "snowdonia", ConfigHandler.snowdoniaWeight, false, ConfigHandler.spawnSnowdonia, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WET);
    }

    private static Biome explorerBiome(Biome biome, String name, int weight, Boolean village, Boolean allowed, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        if (allowed.booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        if (village.booleanValue()) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)village);
        }
        return biome;
    }
}

